/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected;

import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.System2;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpWsClient;
import org.sonarqube.ws.client.WsResponse;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.container.connected.CloseableWsResponse;

public class SonarLintWsClient {
    private static final Logger LOG = LoggerFactory.getLogger(SonarLintWsClient.class);
    private final HttpWsClient client;
    private final String userAgent;

    public SonarLintWsClient(ServerConfiguration serverConfig) {
        this.userAgent = serverConfig.getUserAgent();
        this.client = SonarLintWsClient.buildClient(serverConfig);
    }

    private static HttpWsClient buildClient(ServerConfiguration serverConfig) {
        HttpConnector connector = new HttpConnector.Builder().url(serverConfig.getUrl()).userAgent(serverConfig.getUserAgent()).credentials(serverConfig.getLogin(), serverConfig.getPassword()).proxy(serverConfig.getProxy()).proxyCredentials(serverConfig.getProxyLogin(), serverConfig.getProxyPassword()).readTimeoutMilliseconds(serverConfig.getReadTimeoutMs()).connectTimeoutMilliseconds(serverConfig.getConnectTimeoutMs()).build();
        return new HttpWsClient(connector);
    }

    public CloseableWsResponse get(String path) {
        CloseableWsResponse response = this.rawGet(path);
        if (!response.isSuccessful()) {
            throw SonarLintWsClient.handleError(response);
        }
        return response;
    }

    public CloseableWsResponse rawGet(String path) {
        long startTime = System2.INSTANCE.now();
        GetRequest request = new GetRequest(path);
        WsResponse response = this.client.wsConnector().call(request);
        long duration = System2.INSTANCE.now() - startTime;
        LOG.debug("{} {} {} | time={}ms", new Object[]{request.getMethod(), response.code(), response.requestUrl(), duration});
        return new CloseableWsResponse(response);
    }

    public static RuntimeException handleError(CloseableWsResponse toBeClosed) {
        try (CloseableWsResponse failedResponse = toBeClosed;){
            if (failedResponse.code() == 401) {
                IllegalStateException illegalStateException = new IllegalStateException("Not authorized. Please check server credentials.");
                return illegalStateException;
            }
            if (failedResponse.code() == 403) {
                IllegalStateException illegalStateException = new IllegalStateException(SonarLintWsClient.tryParseAsJsonError(failedResponse.content()));
                return illegalStateException;
            }
            IllegalStateException illegalStateException = new IllegalStateException("Error " + failedResponse.code() + " on " + failedResponse.requestUrl() + (failedResponse.hasContent() ? ": " + SonarLintWsClient.tryParseAsJsonError(failedResponse.content()) : ""));
            return illegalStateException;
        }
    }

    private static String tryParseAsJsonError(String responseContent) {
        try {
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(responseContent).getAsJsonObject();
            JsonArray errors = obj.getAsJsonArray("errors");
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (JsonElement e : errors) {
                errorMessages.add(e.getAsJsonObject().get("msg").getAsString());
            }
            return Joiner.on(", ").join(errorMessages);
        }
        catch (Exception e) {
            return responseContent;
        }
    }

    public String getUserAgent() {
        return this.userAgent;
    }
}

